<?php
function check_admin_auth() {
    if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
        header('Location: ../admin/login.php');
        exit;
    }
}

function login_user($username, $password) {
    global $db;
    
    $user = $db->query(
        "SELECT * FROM users WHERE username = ? AND is_active = 1",
        [$username]
    )->fetch();
    
    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_username'] = $user['username'];
        $_SESSION['user_fullname'] = $user['full_name'];
        $_SESSION['user_role'] = $user['role'];
        return true;
    }
    
    return false;
}

function logout_user() {
    session_destroy();
    header('Location: login.php');
    exit;
}
?>