<?php
require_once '../includes/database.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

check_admin_auth();
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    $db = new Database();
    
    $pi_data = [
        'customer_id' => $_POST['customer_id'],
        'inquiry_id' => $_POST['inquiry_id'],
        'items' => json_encode($_POST['items']),
        'subtotal' => floatval($_POST['subtotal']),
        'tax_rate' => floatval($_POST['tax_rate']),
        'tax_amount' => floatval($_POST['tax_amount']),
        'total_amount' => floatval($_POST['total_amount']),
        'currency' => $_POST['currency'],
        'validity_date' => $_POST['validity_date'],
        'terms_conditions' => $_POST['terms_conditions']
    ];
    
    $pi_id = create_proforma_invoice($db, $pi_data);
    
    if ($pi_id) {
        // Update inquiry status
        $db->query(
            "UPDATE product_inquiries SET status = 'quoted' WHERE id = ?",
            [$pi_data['inquiry_id']]
        );
        
        echo json_encode([
            'success' => true,
            'message' => 'Proforma Invoice created successfully!',
            'pi_id' => $pi_id,
            'pi_number' => $db->query("SELECT pi_number FROM proforma_invoices WHERE id = ?", [$pi_id])->fetch()['pi_number']
        ]);
    } else {
        throw new Exception('Failed to create Proforma Invoice');
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>